//
//  $Id: NSString_FJNFullwidthHalfwidth.h 95 2009-06-11 15:58:03Z fujidana $
//  Copyright (c) 2006-2009 Fujidana All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum {
	FJDNWhiteSpace = 0x01, 
	
	FJDNDecimalDigits = 0x02,
	FJDNBasicLatinLetters = 0x04,
	FJDNBasicLatinSymbols = 0x08,
	FJDNBasicLatinAllCharacters = 0x02 | 0x04 | 0x08,
	
	FJDNBasicJapaneseAllCharacters = 0x10, 
	FJDNOtherCharacters = 0x80
} FJDNUnicharOptions;

enum {
	FJDNNotVoiced = 0, 
	FJDNVoiced, 
	FJDNSemiVoiced
};

@interface NSString (FJNFullwidthHalfwidth)

// -- Returns a string with each Japanese and basic Latin character and white space from the receiver changed to its corresponding halfwidth value. Other characters than Japanese, basic Latin, or white space are discarded. --
- (NSString *)halfwidthString;

// -- Returns a string with each Japanese and basic Latin character and white space from the receiver changed to its corresponding fullwidth value. Other characters than Japanese, basic Latin, or white space remain unchanged. --
- (NSString *)fullwidthString;

// -- Returns a string with each Japanese halfwidth characters from the receiver changed to its corresponding fullwidth value. Other characters remain unchanged. --
- (NSString *)stringByReplacingHalfwidthKanaToFullwidthKana;

// -- Returns a string with each character selected from the receiver changed to its corresponding fullwidth or halfwidth value. Characters This method is used internally in methods above. --
- (NSString *)stringWithConvertFullwidthToHalfwidthOptions:(unsigned)convertFwToHwMask
						convertHalfwidthToFullwidthOptions:(unsigned)convertHwToFwMask 
									  passFullwidthOptions:(unsigned)passFwMask 
									  passHalfwidthOptions:(unsigned)passHwMask;

// -- Returns a string with each Japanese KATAKANA characters from the receiver changed to its corresponding HIRAGANA value. Other characters remain unchanged. Remind that the following characters do not have corresponding HIRAGANA characters in Unicode: fullwidth KATAKANA characters VA, VI, VE, VO (0x30f7 to 0x30fa) and halfwidth KATAKANA characters. These characters also remain unchanged. --
- (NSString *)hiraganaString;

// -- Returns a string with each Japanese HIRAGANA characters from the receiver changed to its corresponding KATAKANA value. Other characters remain unchanged. --
- (NSString *)katakanaString;

@end
